//Dustin Soodak



//behavior 017:
//shot 10:
//determine direction of bump and run
//edit "//flash lights" section in MoveWithOptions() in MiscHardware file to change 
//color (or speed) of lights, or make them stop blinking.
#include "MiscHardware.h"
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  PlayChirp(1000, 50);SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  PlayChirp(1000, 0);SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();  
}
#include "Navigation.h"
extern int32_t AverGyroVelocity;
int i,n,accelx,accely,bumpdir,heading,currentheading,degr;
int32_t largenum;
void loop(){
  SwitchPixelsToButton();SwitchMotorsToSerial();
  RestartTimer();  
  RxIRRestart();
  while(1){
    if(IsIRDone()){
      RxIRStop();
      for(i=0;i<IRNumOfBytes;i++){
        Serial.println(((unsigned char)IRBytes[i]),HEX);
      }
      if(IRBytes[2]==0x45 && IRBytes[3]==0xBA){//power//if(IRBytes[2]==0x44 && IRBytes[3]==0xBB)//test//
        IRBytes[2]=0;IRBytes[3]=0;break;
      }
      else{
        RxIRRestart();SwitchPixelsToButton();
      }
      if(ButtonPressed()){
        delay(1000);break; 
      }
    }//end if(IsIRDone())
  }//end while(1) wait for robot or IR button
  
  SwitchButtonToPixels();
  SetPixelRGB(4,200,0,0);RefreshPixels();
  delay(100);
  SetPixelRGB(4,0,0,0);RefreshPixels();
  NavigationBegin(); 
  RestartTimer();
  while(1){
    //SimpleNavigation();//only shows the latest acceleration, which is often in different direction than initial bump
    //accelx=GetAccelerationX();
    //accely=GetAccelerationY();
    //instead: work with current raw values:
    n=AccelBufferSize();    
    if(n){
      AccelGetAxes(AccelAcceleration);
      AccelAcceleration[0]=AccelAcceleration[0]-AccelZeroes[0];//x-axis raw
      AccelAcceleration[1]=AccelAcceleration[1]-AccelZeroes[1];//y-axis raw
    }
    accelx=-AccelAcceleration[0];//still raw x, but facing correct direction
    accely=-AccelAcceleration[1];//still raw y, but facing correct direction
    //if(GetTime()>200){
    //  Serial.print(accelx,DEC);Serial.print(" ");Serial.println(accely,DEC);
    //  RestartTimer(); 
    //}
    if(abs(accelx)>4000 || abs(accely)>4000){
      bumpdir=180+(90-atan2(accely,accelx)*180/3.14159);
      heading=GetDegrees()+bumpdir;  
      RestartTimer();
      SwitchButtonToPixels();
      SetPixelRGB(4,200,0,0);RefreshPixels();    
      while(GetTime()<100){//wait till is is most likely skidding skidding
        SimpleGyroNavigation();//look at gyroscope as it turns
      }
      AccelGetAxes(AccelAcceleration);
      AccelAcceleration[0]=AccelAcceleration[0]-AccelZeroes[0];//x-axis raw
      AccelAcceleration[1]=AccelAcceleration[1]-AccelZeroes[1];//y-axis raw
      largenum=((int32_t)accelx)*(-AccelAcceleration[0])+((int32_t)accely)*(-AccelAcceleration[1]);//dot product of old & new {xaccel,yaccel}
      if(largenum>0){//largenum is now = cosine of angle between new and old multiplied by their amplitudes
        bumpdir-=180;//if skid direction within 180 degrees of bump direction, then "bump" was probably actually part of skid
        //or can put code here to check again in 20ms, just in case this is just an artifact of vibration        
      }
      //would normally wait here for it to stop and zero the sensors, but want it to be able to run away quickly
      Serial.print(accelx,DEC);Serial.print(" ");Serial.println(accely,DEC);
      SetPixelRGB(4,0,0,0);RefreshPixels();
      currentheading=GetDegrees();
      degr=heading-currentheading;
      //the following makes sure it turns the least distance (in degrees) to point at the source of the disturbance
      if(degr>=0){
        if(degr>=360) degr-=360;
        if(degr>180) degr=-(360-degr);
      }
      else{
        if(degr<=-360) degr+=360;
        if(degr<-180) degr=(360-(-degr));
      }
      SwitchMotorsToSerial();
      Serial.print(" reldir ");Serial.print(bumpdir,DEC);
      Serial.print(" absdir ");Serial.print(heading,DEC);
      Serial.print(" now facing ");Serial.print(currentheading,DEC);
      Serial.print(" turn ");Serial.print(degr,DEC);
      Serial.print(" (");Serial.print(largenum,DEC);Serial.println(")");
      //behavior: (where currentheading+degr is the heading of the offending poke)
      //piss pants and run away
      if(degr>0)
        degr-=180;
      else{
        degr+=180; 
      }  
      SetPixelRGB(2,100,100,0);SetPixelRGB(3,100,100,0);RefreshPixels();      
      MoveWithOptions(currentheading+degr, 200, 900, 1000, 500, 0,0); 
      ZeroNavigationSensors();//since we aren't waiting for it to stop before running away, sensors might have been zeroed in motion
      SetAllPixelsRGB(0,0,0);RefreshPixels();
      SwitchMotorsToSerial();
      //end piss pants and run away   
    }//end if(abs(accelx)>4000 || abs(accely)>4000)
  }//end while(1)  
  
}//end loop()

